/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils.att;

import filenet.vw.api.VWAttachment;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.ws.listener.axis.SOAPMessageUtils;
import filenet.ws.utils.WSLogger;
import filenet.ws.utils.att.IWSAttSaver;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.encoding.Base64;
import org.apache.axis.types.HexBinary;

public class AttachmentHelper {
    protected static Logger logger = Logger.getLogger("filenet.ws.utils.att");
    private static final String m_className = "AttachmentHelper";

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 18:12:00  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.11  $";
    }

    private static void traceHashtableKeys(Hashtable ht, String title) {
        int nItems;
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        int n = nItems = ht == null ? 0 : ht.size();
        if (nItems == 0) {
            return;
        }
        StringBuffer buf = new StringBuffer(title).append("(").append(nItems).append("): >>");
        Enumeration enumKeys = ht.keys();
        while (enumKeys.hasMoreElements()) {
            Object key = enumKeys.nextElement();
            Object value = ht.get(key);
            buf.append(key).append("=").append(value).append(",");
        }
        buf.append("<<");
        if (logger.isFinest()) {
            logger.finest(m_className, "traceHashtableKeys", buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String storeAttachments(SOAPMessage msg, IWSAttSaver saver, String titlePrefix, WSLogger wsLogger) {
        String m_method = "storeAttachments";
        logger.entering(m_className, "storeAttachments");
        try {
            AttachmentPart att;
            if (msg == null || saver == null) {
                String string = null;
                return string;
            }
            int nAttachments = msg.countAttachments();
            if (logger.isFinest()) {
                logger.finest(m_className, "storeAttachments", Integer.toString(nAttachments) + " attachments");
            }
            if (nAttachments == 0) {
                String string = null;
                return string;
            }
            SOAPBody body = msg.getSOAPPart().getEnvelope().getBody();
            Hashtable t1 = new Hashtable(1);
            Hashtable t2 = new Hashtable(1);
            SOAPMessageUtils.inspectAttribute((SOAPElement)body, t1, t2, "href");
            AttachmentHelper.traceHashtableKeys(t1, "storeAttachments CID<->ELEMENTS");
            AttachmentHelper.traceHashtableKeys(t2, "storeAttachments CID<->NAMES");
            Iterator attIter = msg.getAttachments();
            boolean changeIt = false;
            while (attIter.hasNext()) {
                att = (AttachmentPart)attIter.next();
                String cid = "cid:" + att.getContentId();
                if (!t1.containsKey(cid)) {
                    if (!logger.isFinest()) continue;
                    logger.finest(m_className, "storeAttachments", cid + " NOT FOUND in MESSAGE");
                    continue;
                }
                SOAPElement el = (SOAPElement)t1.get(cid);
                Name attrName = (Name)t2.get(cid);
                String elementName = el.getElementName().getLocalName();
                String docTitle = titlePrefix + " " + elementName;
                String docFileName = null;
                Iterator attr_iter = el.getAllAttributes();
                boolean foundName = false;
                boolean foundTitle = false;
                if (attr_iter != null) {
                    while (attr_iter.hasNext()) {
                        Name attrn = (Name)attr_iter.next();
                        if (attrn.getLocalName().equals("docTitle")) {
                            String s = el.getAttributeValue(attrn);
                            if (s != null && s.trim().length() > 0) {
                                docTitle = docTitle + " " + s.trim();
                            }
                            foundTitle = true;
                        }
                        if (attrn.getLocalName().equals("docFileName")) {
                            docFileName = el.getAttributeValue(attrn);
                            foundName = true;
                        }
                        if (!foundTitle || !foundName) continue;
                        break;
                    }
                }
                VWAttachment vwatt = saver.saveAttachment(att, docTitle, docFileName);
                changeIt = true;
                el.removeAttribute(attrName);
                el.addAttribute(attrName, vwatt.toString());
                if (wsLogger == null) continue;
                wsLogger.append("Attachment <").append(elementName).append(">=").append(vwatt).eoln();
            }
            if (!changeIt) {
                att = null;
                return att;
            }
            String res = SOAPMessageUtils.getBodyChildElementsAsString(body);
            if (logger.isFinest()) {
                logger.finest(m_className, "storeAttachments", res);
            }
            String string = res;
            return string;
        }
        catch (Throwable t) {
            logger.throwing(m_className, "storeAttachments", t);
            String string = null;
            return string;
        }
        finally {
            logger.exiting(m_className, "storeAttachments");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeAttachments(SOAPMessage msg, WSLogger wsLogger) {
        String m_method = "removeAttachments";
        logger.entering(m_className, "removeAttachments");
        try {
            if (msg == null) {
                String string = null;
                return string;
            }
            int nAttachments = msg.countAttachments();
            if (logger.isFinest()) {
                logger.finest(m_className, "removeAttachments", Integer.toString(nAttachments) + " attachments");
            }
            if (nAttachments == 0) {
                String string = null;
                return string;
            }
            SOAPBody body = msg.getSOAPPart().getEnvelope().getBody();
            Hashtable t1 = new Hashtable(1);
            Hashtable t2 = new Hashtable(1);
            SOAPMessageUtils.inspectAttribute((SOAPElement)body, t1, t2, "href");
            AttachmentHelper.traceHashtableKeys(t1, "removeAttachments CID<->ELEMENTS");
            AttachmentHelper.traceHashtableKeys(t2, "removeAttachments CID<->NAMES");
            Iterator attIter = msg.getAttachments();
            while (attIter.hasNext()) {
                AttachmentPart att = (AttachmentPart)attIter.next();
                String cid = "cid:" + att.getContentId();
                if (!t1.containsKey(cid)) {
                    if (!logger.isFinest()) continue;
                    logger.finest(m_className, "removeAttachments", cid + " NOT FOUND in MESSAGE");
                    continue;
                }
                SOAPElement el = (SOAPElement)t1.get(cid);
                Name attrName = (Name)t2.get(cid);
                String elementName = el.getElementName().getLocalName();
                VWAttachment vwatt = new VWAttachment();
                el.removeAttribute(attrName);
                el.addAttribute(attrName, vwatt.toString());
                if (wsLogger == null) continue;
                wsLogger.append("Removing Attachment <").append(elementName).append(">=").append(vwatt).eoln();
            }
            String res = SOAPMessageUtils.getBodyChildElementsAsString(body);
            if (logger.isFinest()) {
                logger.finest(m_className, "removeAttachments", res);
            }
            String string = res;
            return string;
        }
        catch (Throwable t) {
            logger.throwing(m_className, "removeAttachments", t);
            String string = null;
            return string;
        }
        finally {
            logger.exiting(m_className, "removeAttachments");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getFileContent(String inFileName) throws Exception {
        if (inFileName == null) {
            throw new Exception("Null filename");
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(inFileName);
            int size = in.available();
            if (size == 0) {
                throw new Exception(inFileName + " is empty.");
            }
            byte[] res = new byte[size];
            in.read(res);
            byte[] byArray = res;
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block25: {
            try {
                byte[] fc;
                FileOutputStream outFile;
                VWCommandLineArgs c = new VWCommandLineArgs(args);
                if (c.isPresent("h")) {
                    System.out.println("Usage:");
                    System.out.println("AttachmentHelper /hex /e infilename /o outfilename");
                    System.out.println("   or            /base64 /d infilename /o outfilename");
                    System.out.println("/e for encoding");
                    System.out.println("/d for decoding");
                    System.exit(0);
                }
                boolean isBase64 = c.isPresent("base64");
                boolean isHex = c.isPresent("hex");
                if (!isBase64 && !isHex) {
                    System.out.println("Need ot specify hex or base64");
                    System.exit(1);
                }
                if (isBase64 && isHex) {
                    System.out.println("base64 will be used.");
                    isHex = false;
                }
                String outFileName = c.getParameter("o");
                String encFileName = c.getParameter("e");
                String decFileName = c.getParameter("d");
                if (encFileName != null && decFileName != null) {
                    System.out.println("Either encoding or decoding, but not both..");
                    System.exit(1);
                }
                if ((encFileName != null || decFileName != null) && outFileName == null) {
                    System.out.println("Missing outfile name..");
                    System.exit(1);
                }
                if (encFileName != null) {
                    if (isBase64) {
                        System.out.println("base64 encode file " + encFileName + " TO " + outFileName);
                    }
                    if (isHex) {
                        System.out.println("hexBinary encode file " + encFileName + " TO " + outFileName);
                    }
                    outFile = null;
                    try {
                        fc = AttachmentHelper.getFileContent(encFileName);
                        outFile = new FileOutputStream(outFileName);
                        if (isBase64) {
                            Base64.encode((byte[])fc, (int)0, (int)fc.length, (OutputStream)outFile);
                        }
                        if (isHex) {
                            String s = HexBinary.encode((byte[])fc);
                            outFile.write(s.getBytes());
                        }
                        System.exit(0);
                    }
                    finally {
                        if (outFile != null) {
                            outFile.close();
                        }
                    }
                }
                if (decFileName == null) break block25;
                if (isBase64) {
                    System.out.println("base64 decode file " + decFileName + " TO " + outFileName);
                }
                if (isHex) {
                    System.out.println("hexBinary decode file " + decFileName + " TO " + outFileName);
                }
                outFile = null;
                try {
                    fc = AttachmentHelper.getFileContent(decFileName);
                    outFile = new FileOutputStream(outFileName);
                    if (isBase64) {
                        Base64.decode((String)new String(fc), (OutputStream)outFile);
                    }
                    if (isHex) {
                        outFile.write(HexBinary.decode((String)new String(fc)));
                    }
                    System.exit(0);
                }
                finally {
                    if (outFile != null) {
                        outFile.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        System.exit(0);
    }
}

